# 🔧 TROUBLESHOOTING GUIDE

## ❌ "Cannot GET /" or "404 Not Found"

### Cause
Server is not serving the game.html file

### Solution

**Option 1: Make sure server is running**
```bash
# Kill any existing process on port 8080
lsof -i :8080          # (Mac/Linux)
netstat -ano | grep 8080  # (Windows)

# Then restart server
npm start
```

**Option 2: Verify file exists**
```bash
# Check if game.html is in the right location
ls -la game.html       # (Mac/Linux)
dir game.html          # (Windows)
```

**Option 3: Clear browser cache**
- Press `Ctrl+Shift+Delete` (Windows/Linux) or `Cmd+Shift+Delete` (Mac)
- Clear all cache
- Try again

---

## ❌ "npm: command not found" or "npm is not recognized"

### Cause
Node.js is not installed or not in PATH

### Solution

1. **Download and install Node.js** from https://nodejs.org/
2. **Verify installation**:
   ```bash
   node --version
   npm --version
   ```
3. **Restart your terminal/command prompt**
4. **Try again**: `npm install`

---

## ❌ "Port 8080 already in use" or "EADDRINUSE"

### Cause
Another application is using port 8080

### Solution

**Mac/Linux:**
```bash
# Find process using port 8080
lsof -i :8080

# Kill the process
kill -9 <PID>

# Or change port in server.js
# Find: const PORT = process.env.PORT || 8080;
# Change to: const PORT = process.env.PORT || 3000;
```

**Windows:**
```bash
# Find process using port 8080
netstat -ano | grep 8080

# Kill the process
taskkill /PID <PID> /F

# Or change port in server.js
```

---

## ❌ "WebSocket connection failed" or "Cannot connect"

### Cause
Server is not running or WebSocket is blocked

### Solution

1. **Check server is running**
   ```bash
   npm start
   # Should show: Server running on ws://localhost:8080
   ```

2. **Check firewall**
   - Windows: Allow Node.js through firewall
   - Mac: System Preferences → Security & Privacy → Firewall
   - Linux: `sudo ufw allow 8080`

3. **Check correct URL**
   - Should be: `http://localhost:8080`
   - NOT: `http://127.0.0.1:8080` (use localhost)

4. **Try different browser**
   - Chrome, Firefox, Safari, Edge

---

## ❌ "Cannot find module 'express'" or other module errors

### Cause
Dependencies not installed

### Solution

```bash
# Install dependencies
npm install

# Verify all dependencies installed
npm list

# If still issues, clean and reinstall
rm -rf node_modules package-lock.json  # (Mac/Linux)
rmdir /s node_modules  # (Windows)
npm install
```

---

## ❌ Game runs but players don't sync / see each other

### Cause
WebSocket connection not working properly

### Solution

1. **Check browser console** (F12):
   - Look for red error messages
   - Check Network tab → WS (WebSocket)

2. **Restart everything**:
   - Close all browser tabs
   - Stop server with `Ctrl+C`
   - Run `npm start` again
   - Open `http://localhost:8080` in fresh tab

3. **Try incognito/private mode**:
   - Open new incognito window
   - Go to `http://localhost:8080`
   - Test multiplayer with two incognito windows

4. **Check server console**:
   - Should show connection logs
   - Look for error messages

---

## ❌ Game lags / low FPS / stuttering

### Cause
Too many players, network lag, or low device performance

### Solution

1. **Reduce player count**
   - Close extra browser tabs
   - Edit `server.js`: `maxPlayersPerRoom: 4` (reduce from 8)

2. **Check network**
   - Ping: Should be <200ms
   - Test: `ping 8.8.8.8` (Google DNS)

3. **Close other applications**
   - Close Chrome extensions
   - Close other heavy applications
   - Free up RAM

4. **Update browser**
   - Check for latest Chrome/Firefox/Safari
   - Clear browser cache and cookies

5. **Lower resolution**
   - Browser zoom: Ctrl+- (minus sign)
   - Zoom to 80-90%

---

## ❌ Game works locally but won't deploy / work on other computer

### Cause
Different IP address or firewall issue

### Solution

**For local network**:
1. Find your computer's IP:
   ```bash
   # Mac/Linux:
   ifconfig | grep "inet "
   
   # Windows:
   ipconfig
   # Look for "IPv4 Address" like 192.168.1.xxx
   ```

2. Other computer connects to:
   ```
   http://YOUR_IP:8080
   # Example: http://192.168.1.5:8080
   ```

3. Allow through firewall:
   - Windows: Windows Defender → Firewall → Allow app
   - Mac: System Preferences → Security & Privacy

**For deployment to server**:
- See SETUP_GUIDE.md for Heroku/Docker/VPS instructions

---

## ❌ Weapons not working / can't shoot

### Cause
Game state not properly initialized

### Solution

1. **Refresh page** with `Ctrl+R` or `Cmd+R`

2. **Wait for page to fully load**
   - Check Network tab (F12)
   - All files should be loaded

3. **Check console for errors** (F12)
   - Red error messages indicate problems
   - Look for ammo/weapon issues

4. **Create new username** and rejoin
   - Sometimes player state gets corrupted

---

## ❌ "ReferenceError: path is not defined"

### Cause
Missing import in server.js

### Solution

Check top of `server.js` has:
```javascript
const path = require('path');
```

If missing, add it after other requires.

---

## ❌ Weapon customization not working

### Cause
weapons.json syntax error

### Solution

1. **Validate JSON**:
   - Use https://jsonlint.com/
   - Paste contents of weapons.json
   - Fix any syntax errors

2. **Common errors**:
   - Missing commas between properties
   - Extra commas before closing braces
   - Single quotes instead of double quotes
   - Unescaped quotes in strings

3. **Restart server** after fixing

---

## ❌ Map doesn't load / blank screen

### Cause
maps.json error or rendering issue

### Solution

1. **Validate maps.json**:
   - Use https://jsonlint.com/
   - Check for syntax errors

2. **Check spawn points**:
   - At least one spawn point required
   - Must have x, y, z coordinates

3. **Browser console errors** (F12):
   - Look for rendering errors
   - Check WebGL support

4. **Try different map**:
   - Maps rotate: arena_01 → arena_02 → arena_03

---

## ❌ Can't login / stuck on login screen

### Cause
Authentication or server connection issue

### Solution

1. **Check server running**:
   - Terminal should show: "Server running on ws://localhost:8080"

2. **Check API endpoint**:
   - Open http://localhost:8080/api/auth/login in browser
   - Should show error (that's normal)

3. **Clear browser data**:
   - F12 → Application → Clear Site Data
   - Refresh page

4. **Check username**:
   - Must be 2+ characters
   - Try simple username like "player1"

---

## ❌ Server crashes with "OutOfMemory" error

### Cause
Too many players or memory leak

### Solution

1. **Limit player count**:
   ```javascript
   // server.js
   maxPlayersPerRoom: 4  // Reduce from 8
   ```

2. **Monitor memory**:
   ```bash
   node --max-old-space-size=1024 server.js
   ```

3. **Restart server regularly**:
   - Close with `Ctrl+C`
   - Wait 10 seconds
   - Run `npm start` again

---

## ✅ STILL NOT WORKING?

### Debug Steps

1. **Check browser console** (F12):
   ```
   Console tab → Look for red errors
   Network tab → Check if game.html loaded
   Application tab → Check WebSocket connection
   ```

2. **Check server logs**:
   ```
   Terminal where npm start is running
   Look for [INFO], [ERROR], [ANTI-CHEAT] messages
   ```

3. **Test basic connectivity**:
   ```bash
   # Ping the server
   curl http://localhost:8080
   # Should return HTML content
   ```

4. **Try fresh installation**:
   ```bash
   rm -rf node_modules package-lock.json
   npm install
   npm start
   ```

5. **Use different browser**:
   - Chrome, Firefox, Safari, Edge
   - Try incognito/private mode

6. **Report issue with**:
   - Error message (exact text)
   - Steps to reproduce
   - Browser and OS
   - Server logs
   - Browser console errors (screenshot)

---

## 📞 QUICK REFERENCE

| Problem | Quick Fix |
|---------|-----------|
| Can't access game | `npm start` then `http://localhost:8080` |
| Port in use | `kill -9 <PID>` or change port |
| No dependencies | `npm install` |
| WebSocket failed | Restart server and browser |
| Low FPS | Close other apps, reduce players |
| Can't shoot | Refresh page, check console |
| Players not syncing | Restart server, refresh browser |
| Weapon not found | Validate weapons.json with jsonlint |
| Crash on startup | Check Node.js version: `node --version` |

---

**Still need help? Check SETUP_GUIDE.md or README.md for more information! 🎮**
