# ⚔️ TACTICAL WARFARE - Multiplayer Web Shooter

A modern, fast-paced **multiplayer FPS/TPS** web-based shooting game built with Node.js, Socket.io, and HTML5 Canvas.

![Version](https://img.shields.io/badge/version-1.0.0-blue)
![License](https://img.shields.io/badge/license-MIT-green)

---

## 📋 Features

### Core Gameplay
✅ **Real-time Multiplayer** - Up to 8 players per match
✅ **Smooth Movement System** - WASD controls with sprinting, crouching, jumping
✅ **Advanced Shooting Mechanics** - Hitscan with recoil, bullet spread, and damage falloff
✅ **Weapon System** - 4 primary weapons + pistol + grenades
✅ **Health & Armor** - Damage mitigation system
✅ **Kill Tracking** - Live kill feed and scoreboard

### Multiplayer Features
✅ **Server Authoritative** - Anti-cheat architecture
✅ **Client Prediction** - Smooth lag compensation
✅ **Position Syncing** - 30-60 TPS network updates
✅ **Matchmaking** - Quickplay and room codes
✅ **Real-time Scoreboard** - Live player stats

### User Experience
✅ **Modern UI** - Minimalist HUD with kill feed
✅ **Dynamic Crosshair** - Reticle-based aiming
✅ **Responsive Design** - Works on all devices
✅ **Sound Ready** - Architecture for audio effects
✅ **Performance Optimized** - 60 FPS on mid-range devices

---

## 🚀 Quick Start

### Prerequisites
- Node.js 14+ (download from https://nodejs.org)
- npm or yarn
- Modern web browser (Chrome, Firefox, Safari, Edge)

### Installation

**1. Clone or extract the project**
```bash
cd /path/to/multiplayer-shooter
```

**2. Install server dependencies**
```bash
cd server
npm install
```

**3. Start the server**
```bash
npm start
```

You should see:
```
🎮 Game Server running on http://localhost:3000
```

**4. Open in browser**
Navigate to `http://localhost:3000` in your browser

**5. Start playing**
- Enter a username
- Click "PLAY" to start a new match
- Or join an existing room with a code

---

## 🎮 Gameplay Controls

| Action | Key(s) |
|--------|--------|
| **Move Forward** | W / ↑ Arrow |
| **Move Backward** | S / ↓ Arrow |
| **Strafe Left** | A / ← Arrow |
| **Strafe Right** | D / → Arrow |
| **Sprint** | SHIFT |
| **Jump** | SPACE |
| **Crouch** | C |
| **Aim** | Right Mouse Button |
| **Fire** | Left Mouse Click |
| **Reload** | R |
| **Weapon 1** | 1 (M4 Carbine) |
| **Weapon 2** | 2 (Glock 18) |
| **Weapon 3** | 3 (AK-47) |
| **Weapon 4** | 4 (AWP Dragon Lore) |

---

## 🔫 Weapon System

### Primary Weapons

**M4 Carbine** (Default)
- Damage: 28
- Fire Rate: 90ms
- Magazine: 30
- Accuracy: Very High
- Range: 150m

**AK-47**
- Damage: 35
- Fire Rate: 110ms
- Magazine: 30
- Accuracy: Medium
- Range: 130m

**MP5K** (Submachine Gun)
- Damage: 18
- Fire Rate: 50ms (Fast!)
- Magazine: 30
- Accuracy: Medium
- Range: 80m

**AWP Dragon Lore** (Sniper)
- Damage: 90 (One-shot kill!)
- Fire Rate: 1500ms
- Magazine: 10
- Accuracy: Extreme
- Range: 250m

### Secondary Weapon

**Glock 18** (Pistol)
- Damage: 20
- Fire Rate: 100ms
- Magazine: 20
- Always available for respawn

---

## 🏗️ Project Architecture

```
multiplayer-shooter/
├── server/                    # Node.js Backend
│   ├── index.js              # Main server (Socket.io, Express)
│   ├── weapons.json          # Weapon configurations
│   └── package.json          # Dependencies
│
├── client/                    # Web Frontend
│   ├── index.html            # Main HTML page
│   ├── game.js               # Game client logic
│   └── styles.css            # UI styles (in HTML)
│
└── README.md                 # This file
```

### Server Architecture

```
┌─────────────────────────────────────────┐
│      Express.js HTTP Server              │
├─────────────────────────────────────────┤
│  Socket.io - Real-time Communication    │
├─────────────────────────────────────────┤
│  Game Logic & State Management          │
│  • Player Manager                       │
│  • Room Manager                         │
│  • Hit Detection (Server Auth.)         │
│  • Game Tick Loop (60 Hz)               │
└─────────────────────────────────────────┘
```

### Client Architecture

```
┌──────────────────────────────────────────┐
│        HTML5 Canvas Game Loop            │
├──────────────────────────────────────────┤
│  GameClient Class                        │
│  • Input Handling                        │
│  • Client-side Prediction                │
│  • Rendering                             │
│  • UI Management                         │
├──────────────────────────────────────────┤
│  Socket.io - Network Communication      │
├──────────────────────────────────────────┤
│  Server: Express.js (HTTP + WebSocket)  │
└──────────────────────────────────────────┘
```

---

## 🌐 Network Protocol

### Socket Events

#### Client → Server

| Event | Data | Description |
|-------|------|-------------|
| `joinGame` | `{username, roomCode}` | Join a game session |
| `playerInput` | `{forward, backward, left, right, sprint, angle}` | Player movement & aim |
| `shoot` | `{weaponId, timestamp}` | Fire weapon |
| `reload` | - | Reload current weapon |

#### Server → Client

| Event | Data | Description |
|-------|------|-------------|
| `playerJoined` | `{player, roomState}` | New player joined |
| `gameState` | `{players, scoreboard, mapId}` | Full game state update |
| `playerPositionUpdate` | `{playerId, x, y, angle}` | Player position sync |
| `bulletFired` | `{playerId, hits, damage}` | Bullet fired with hit info |
| `playerLeft` | `{playerId}` | Player disconnected |

### Tick Rate

- **Server Update Rate**: 60 TPS (16.67ms per tick)
- **Position Sync Rate**: 30 Hz (bandwidth optimization)
- **Bullet Detection**: Server-authoritative each shot

---

## 🎯 Game Mechanics

### Damage System

```
Damage Calculation:
  1. Base Damage (from weapon)
  2. Distance Falloff (damage decreases with range)
  3. Armor Absorption (75% of remaining damage)
  4. Headshot Multiplier (2x damage)
  
  Final Damage = Base × Distance × (1 - Armor%) × Headshot Multiplier
```

### Spread & Recoil

Each weapon has:
- **Spread**: Bullet deviation angle (radians)
- **Recoil**: Camera/weapon kickback

Automatic weapons have higher spread than precision rifles.

### Movement

```
Max Speed: 0.15 units/frame
Sprint Speed: 0.27 units/frame (1.8x)
Acceleration: Instant (arcade style)
Friction: 0.95 (5% slowdown per frame)
```

---

## 📊 API Endpoints

### GET `/api/rooms`
List all available game rooms
```json
[
  {
    "id": "uuid",
    "name": "Game 1",
    "playerCount": 4,
    "maxPlayers": 8,
    "gameState": "playing"
  }
]
```

### GET `/api/health`
Server health check
```json
{
  "status": "online",
  "players": 12,
  "rooms": 3
}
```

---

## 🔒 Security & Anti-Cheat

### Server Authoritative Design
- ✅ Hit detection happens on server
- ✅ Player positions verified each tick
- ✅ Damage calculated server-side
- ✅ Anti-speedhack position validation
- ✅ Anti-aimbot angle checks

### Planned Features
- [ ] JWT Authentication
- [ ] Rate limiting
- [ ] Behavior analysis
- [ ] VAC-style anti-cheat

---

## ⚙️ Configuration

### Server Config (index.js)

```javascript
const GAME_CONFIG = {
  TICK_RATE: 60,              // Server ticks per second
  PLAYER_SPEED: 0.15,         // Base movement speed
  SPRINT_MULTIPLIER: 1.8,     // Sprint speed multiplier
  JUMP_FORCE: 0.25,           // Jump velocity
  GRAVITY: 0.01,              // Gravity acceleration
  MAP_WIDTH: 200,             // Map width (game units)
  MAP_HEIGHT: 200             // Map height (game units)
};
```

### Client Config (game.js)

```javascript
this.TICK_RATE = 60;          // Client render FPS
this.VIEWPORT_SCALE = 3;      // Pixels per game unit
this.MAP_WIDTH = 200;
this.MAP_HEIGHT = 200;
```

---

## 🛠️ Development

### Modifying Weapons

Edit `server/weapons.json`:

```json
{
  "id": 0,
  "name": "New Weapon",
  "type": "assault_rifle",
  "damage": 30,
  "fireRate": 100,
  "range": 150,
  "magazine": 30,
  "reloadTime": 2.5,
  "spread": 0.08
}
```

Then reference in `client/game.js` `loadWeapons()` method.

### Adding New Maps

1. Create map data in server
2. Define cover positions
3. Set spawn locations
4. Reference in room creation

### Creating Custom Game Modes

Extend the `GameRoom` class:

```javascript
class TDMRoom extends GameRoom {
  constructor(id, name) {
    super(id, name);
    this.mode = 'tdm';
    this.teamA = [];
    this.teamB = [];
  }
  
  // Custom logic here
}
```

---

## 🐛 Troubleshooting

### "Cannot find module 'socket.io'"
```bash
cd server
npm install
```

### Port 3000 already in use
```bash
# Use custom port
PORT=3001 npm start
```

### Connection timeout
- Check firewall settings
- Ensure server is running
- Verify correct localhost address

### Lag/High ping
- Check network connection
- Server may be overloaded
- Reduce other applications

---

## 📈 Performance

### Target Performance
- ✅ 60 FPS on mid-range devices
- ✅ Sub-100ms latency on LAN
- ✅ Smooth at 50Mbps+ internet
- ✅ <5MB memory footprint (client)

### Optimization Techniques
- Object pooling for bullets
- Dirty-flag rendering
- Delta compression for network
- Spatial partitioning ready

---

## 📚 Learning Resources

- [Socket.io Documentation](https://socket.io/docs/)
- [HTML5 Canvas API](https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API)
- [Node.js Guide](https://nodejs.org/en/docs/)
- [Game Development Best Practices](https://gamedev.stackexchange.com/)

---

## 🚀 Roadmap

### v1.1
- [ ] Voice chat (WebRTC)
- [ ] Custom player skins
- [ ] Leaderboards & ranks
- [ ] Clan system

### v2.0
- [ ] 3D graphics (Three.js migration)
- [ ] More weapons & attachments
- [ ] Map editor
- [ ] Custom game modes
- [ ] Mobile support

### v3.0
- [ ] Trading system
- [ ] Tournaments
- [ ] Spectator mode
- [ ] Replay system

---

## 📄 License

MIT License - Feel free to use for personal and commercial projects.

---

## 👥 Contributing

Issues and pull requests welcome! To contribute:

1. Fork the repository
2. Create feature branch (`git checkout -b feature/amazing-feature`)
3. Commit changes (`git commit -m 'Add amazing feature'`)
4. Push to branch (`git push origin feature/amazing-feature`)
5. Open Pull Request

---

## 💬 Support

- **Issues**: Report bugs via GitHub Issues
- **Discussions**: Ask questions in Discussions
- **Discord**: [Join our community](discord.gg/example)

---

## 🎓 Learning Path

New to game development? Follow this path:

1. **Understand the Architecture** (read this README)
2. **Run the Game** (npm start & play)
3. **Explore Server Code** (read index.js)
4. **Explore Client Code** (read game.js)
5. **Modify Weapons** (edit weapons.json)
6. **Add Features** (extend GameClient class)
7. **Deploy** (Heroku, Railway, or own server)

---

## 🎬 Quick Examples

### Create a Private Room

```javascript
// Server-side
const room = new GameRoom(uuidv4(), "Private Game", 4);
rooms.set("secret-code-123", room);

// Client: Use room code "secret-code-123"
```

### Add a Custom Weapon

```json
{
  "id": 8,
  "name": "Golden AK",
  "damage": 40,
  "fireRate": 100,
  "range": 150,
  "magazine": 35
}
```

### Create a Bot Player

```javascript
class BotPlayer extends Player {
  update() {
    // AI logic here
    super.update(aiInput);
  }
}
```

---

## ⭐ Star us on GitHub!

If you find this project useful, please consider giving it a star! ⭐

---

**Happy gaming! Good luck out there, soldier.** 🎯

---

*Last updated: 2024*
*Maintained by: Tactical Warfare Dev Team*
