# ⚔️ ULTIMATE MULTIPLAYER WEB SHOOTER - QUICK START

## ⚡ START IN 2 MINUTES

### Step 1: Install Dependencies
```bash
npm install
```

### Step 2: Start the Server
```bash
npm start
```

You should see:
```
╔════════════════════════════════════════════════════════╗
║   MULTIPLAYER WEB SHOOTER - SERVER                    ║
║   Server running on: ws://localhost:8080              ║
║   API running on: http://localhost:8080               ║
╚════════════════════════════════════════════════════════╝
```

### Step 3: Open Game in Browser
Go to: **`http://localhost:8080`**

Or: **`http://localhost:8080/game.html`**

---

## 🎮 IN-GAME CONTROLS

| Action | Key |
|--------|-----|
| Move Forward | **W** |
| Move Left | **A** |
| Move Right | **D** |
| Move Backward | **S** |
| Sprint | **SHIFT** |
| Crouch | **CTRL** |
| Jump | **SPACE** |
| Aim | **Mouse Move** |
| Fire | **Mouse Click** or **Space** |
| Reload | **R** |
| Switch Weapons | **1-5** |

---

## 🎯 WEAPONS (1-5 Keys)

| Key | Weapon | Type |
|-----|--------|------|
| 1 | M4A1 | Assault Rifle |
| 2 | AK-47 | Assault Rifle |
| 3 | MP5 | Submachine Gun |
| 4 | Shotgun | Close Range |
| 5 | Pistol | Backup |

---

## ❌ TROUBLESHOOTING

### Problem: "Cannot GET /"
**Solution**: Make sure server is running with `npm start`

### Problem: "Connection refused"
**Solution**: 
- Stop any process on port 8080
- Run: `lsof -i :8080` to find it
- Kill it with: `kill -9 <PID>`

### Problem: "Socket hang up"
**Solution**: Restart the server with `npm start`

### Problem: Players not syncing
**Solution**: 
- Open game in different browser tabs/windows
- Refresh all tabs
- Check server console for errors

---

## 🔧 CUSTOMIZATION

### Change Weapon Damage
Edit `weapons.json`:
```json
"ar_15": {
  "damage": 28  // ← Change this
}
```

### Add New Spawn Point
Edit `maps.json`:
```json
"spawnPoints": [
  { "x": 0, "y": 1, "z": 0, "team": "blue" },
  { "x": 10, "y": 1, "z": 10, "team": "red" }  // ← Add new
]
```

### Change Player Speed
Edit `server.js`:
```javascript
const GAME_CONFIG = {
  playerSpeed: 0.15,  // ← Change this (0.25 = faster)
  sprintSpeed: 0.25
};
```

---

## 📊 FILE STRUCTURE

```
/outputs/
├── server.js              ← Server code
├── game.html              ← Game client
├── package.json           ← Dependencies
├── weapons.json           ← Weapon configs
├── maps.json              ← Map configs
└── QUICKSTART.md          ← This file
```

---

## 🚀 DEPLOYMENT

### Local Testing
```bash
npm start
# Open http://localhost:8080
```

### Production (Heroku)
```bash
heroku create your-game-name
git push heroku main
heroku open
```

### Production (VPS)
```bash
ssh root@your-vps
git clone <repo>
cd ultimate-multiplayer-shooter
npm install
npm start
```

---

## 💡 TIPS

✅ Open multiple browser tabs to test multiplayer
✅ Use different usernames for each player
✅ Test weapons and maps
✅ Customize before deploying
✅ Check browser console (F12) for errors

---

## 🎮 GAMEPLAY TIPS

1. **Use Cover** - Hide behind buildings to avoid fire
2. **Manage Ammo** - Reload when safe
3. **Headshots** - 2x damage multiplier
4. **Spray Control** - Weapons have recoil patterns
5. **Watch Radar** - See enemy positions in minimap
6. **Choose Weapon** - Different weapons for different ranges
   - **Sniper**: Long range (1500m)
   - **AR**: Medium range (800m)
   - **SMG**: Short range (350m)
   - **Shotgun**: Very short range (200m)

---

## 🔐 SECURITY FEATURES

✅ Server validates all hits (no client-side damage)
✅ Speed hack detection (monitors movement speed)
✅ Position validation (checks for cheating)
✅ JWT authentication (secure player identity)

---

## 📞 GETTING HELP

1. **Check browser console** (F12)
2. **Check server logs** in terminal
3. **Read README.md** for full documentation
4. **Read SETUP_GUIDE.md** for detailed setup

---

## ✨ WHAT'S INCLUDED

✅ Full multiplayer server
✅ Complete game client
✅ 7 weapons configured
✅ 3 maps designed
✅ Anti-cheat system
✅ Real-time networking
✅ 60 FPS gameplay
✅ Production-ready code

---

**Ready? Run `npm start` and play! 🎮**

