# 🚀 GETTING STARTED - STEP BY STEP

## THE FIX FOR "404 NOT FOUND"

The 404 error has been **FIXED** in the updated `server.js`. Follow these steps:

---

## ✅ STEP 1: Ensure You Have Latest server.js

Make sure your `server.js` has this at the top (around line 19):

```javascript
app.use(express.static(__dirname));  // Serve all files in current directory

// Serve game.html on root
app.get('/', (req, res) => {
  res.sendFile(path.join(__dirname, 'game.html'));
});

app.get('/game.html', (req, res) => {
  res.sendFile(path.join(__dirname, 'game.html'));
});
```

✅ **If you have this, you're good!**
❌ **If you don't, download the latest server.js from outputs**

---

## ✅ STEP 2: Install Dependencies

Open terminal/command prompt in your project folder:

```bash
npm install
```

Wait for it to complete (may take 1-2 minutes)

---

## ✅ STEP 3: Start the Server

```bash
npm start
```

You should see:

```
╔════════════════════════════════════════════════════════╗
║   MULTIPLAYER WEB SHOOTER - SERVER                    ║
║   Server running on: ws://localhost:8080              ║
║   API running on: http://localhost:8080               ║
╚════════════════════════════════════════════════════════╝
```

✅ **If you see this, server is running!**

---

## ✅ STEP 4: Open Game in Browser

**Option A: Direct URL**
```
http://localhost:8080
```

**Option B: With filename**
```
http://localhost:8080/game.html
```

**Option C: Via API**
```
http://localhost:8080/api/config/weapons
```
(This tests the API is working)

---

## 🎮 STEP 5: Play!

1. Enter a username (2+ characters)
2. Click **PLAY**
3. Game loads!

### Testing Multiplayer

Open **2 browser tabs** with different usernames:

**Tab 1**: `http://localhost:8080` → Username: "Player1"
**Tab 2**: `http://localhost:8080` → Username: "Player2"

Both players appear in the same game!

---

## 🎯 TROUBLESHOOTING THIS SPECIFIC ISSUE

### Still getting "404 Not Found"?

**Solution 1: Restart Everything**
```bash
# In terminal, press Ctrl+C to stop server
# Wait 5 seconds
# Run again:
npm start

# Then refresh browser with Ctrl+R
```

**Solution 2: Clear Browser Cache**
1. Press `Ctrl+Shift+Delete` (Windows/Linux) or `Cmd+Shift+Delete` (Mac)
2. Select "All time"
3. Click "Clear data"
4. Go to `http://localhost:8080`

**Solution 3: Check Port 8080**

If port is already in use:

```bash
# Mac/Linux: Find process
lsof -i :8080

# Mac/Linux: Kill process
kill -9 <PID>

# Windows: Find process
netstat -ano | grep 8080

# Windows: Kill process
taskkill /PID <PID> /F

# Then restart server
npm start
```

**Solution 4: Verify Files Exist**

Make sure all these files are in the same folder:
- ✅ `server.js` (the server)
- ✅ `game.html` (the game)
- ✅ `package.json` (dependencies)
- ✅ `weapons.json` (weapon configs)
- ✅ `maps.json` (map configs)

**Solution 5: Check server.js**

Make sure around line 19-28 you have:
```javascript
app.use(express.static(__dirname));

app.get('/', (req, res) => {
  res.sendFile(path.join(__dirname, 'game.html'));
});
```

If you don't, download the latest server.js

---

## 🔍 VERIFY EVERYTHING WORKS

### Test 1: Server Running
Open terminal where npm is running, should see:
```
Server running on: ws://localhost:8080
```

### Test 2: Static Files Served
Open in browser:
```
http://localhost:8080/weapons.json
```
Should show weapon JSON data

### Test 3: Game Loads
Open in browser:
```
http://localhost:8080/game.html
```
Should show game login screen

### Test 4: API Works
Open in browser:
```
http://localhost:8080/api/config/weapons
```
Should show weapon configuration

### Test 5: Multiplayer Works
1. Open browser tab 1: `http://localhost:8080` → Login as "Player1"
2. Open browser tab 2: `http://localhost:8080` → Login as "Player2"
3. Both see each other in game

---

## 💡 QUICK TIPS

✅ **Always use `http://localhost:8080` (not 127.0.0.1)**
✅ **Make sure `npm start` is running before opening game**
✅ **Use `Ctrl+R` to refresh browser, not just F5**
✅ **Check browser console (F12) for errors**
✅ **Check terminal where server is running for error messages**
✅ **Open multiple browser tabs for testing multiplayer**

---

## 📁 EXPECTED FILE LOCATIONS

Everything should be in the SAME folder:

```
your-project-folder/
├── server.js           ← Server code
├── game.html           ← Game client
├── package.json        ← Dependencies
├── weapons.json        ← Weapons config
├── maps.json           ← Maps config
├── node_modules/       ← Created after npm install
└── package-lock.json   ← Created after npm install
```

---

## 🆘 IF IT STILL DOESN'T WORK

1. **Take screenshot** of:
   - Browser error message
   - Terminal/console output
   - URL you're trying to access

2. **Check 5 things**:
   - ✅ Is `npm start` running in terminal?
   - ✅ Does terminal show "Server running on ws://localhost:8080"?
   - ✅ Is browser showing `http://localhost:8080` (not something else)?
   - ✅ Have you tried `Ctrl+Shift+Delete` to clear cache?
   - ✅ Have you tried in incognito/private mode?

3. **Read TROUBLESHOOTING.md** for detailed solutions

---

## 🎉 SUCCESS!

When it works, you'll see:

1. **Browser shows login screen** with username input
2. **Multiple tabs show same game** with different players
3. **Players sync in real-time** as they move
4. **Combat works** - can shoot and kill each other

---

**Still on 404? Go to TROUBLESHOOTING.md for detailed fixes! 🎮**

